/*
 * Decompiled with CFR 0.152.
 */
package com.redpxnda.respawnobelisks.data.recipe;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import com.mojang.logging.LogUtils;
import com.redpxnda.respawnobelisks.registry.ModRegistries;
import com.redpxnda.respawnobelisks.registry.item.CoreItem;
import com.redpxnda.respawnobelisks.util.CoreUtils;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.inventory.CraftingContainer;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.ShapelessRecipe;
import org.slf4j.Logger;

public class CoreMergeRecipe
extends ShapelessRecipe {
    private static final Logger LOGGER = LogUtils.getLogger();
    private final ShapelessRecipe compose;
    private final double multiplier;

    public CoreMergeRecipe(ShapelessRecipe compose, double multiplier) {
        super(compose.m_6423_(), compose.m_6076_(), compose.m_8043_(), compose.m_7527_());
        this.compose = compose;
        this.multiplier = multiplier;
    }

    public ShapelessRecipe getCompose() {
        return this.compose;
    }

    public double getMultiplier() {
        return this.multiplier;
    }

    public boolean m_5598_() {
        return true;
    }

    public ItemStack m_5874_(CraftingContainer inv) {
        List<ItemStack> stacks = CoreMergeRecipe.getCores(inv);
        if (stacks.isEmpty()) {
            return super.m_5874_(inv);
        }
        double totalCharge = CoreUtils.getMaxCharge(stacks.get(0).m_41784_());
        for (ItemStack stack : stacks.subList(1, stacks.size())) {
            totalCharge += CoreUtils.getMaxCharge(stack.m_41784_()) * this.multiplier;
        }
        ItemStack result = stacks.get(0).m_41777_();
        result.m_41764_(1);
        CoreUtils.setMaxCharge(result.m_41784_(), totalCharge);
        return result;
    }

    private static List<ItemStack> getCores(CraftingContainer inv) {
        ArrayList<ItemStack> stacks = new ArrayList<ItemStack>();
        for (int i = 0; i < inv.m_6643_(); ++i) {
            ItemStack stack = inv.m_8020_(i);
            if (!(stack.m_41720_() instanceof CoreItem)) continue;
            stacks.add(stack);
        }
        return stacks;
    }

    public RecipeSerializer<?> m_7707_() {
        return (RecipeSerializer)ModRegistries.CORE_MERGE_SERIALIZER.get();
    }

    public static class Serializer
    extends ShapelessRecipe.Serializer {
        public CoreMergeRecipe fromJson(ResourceLocation resourceLocation, JsonObject jsonObject) {
            double multiplier = 1.0;
            if (jsonObject.has("multiplier")) {
                JsonPrimitive prim;
                JsonElement jsonElement = jsonObject.get("multiplier");
                if (jsonElement instanceof JsonPrimitive && (prim = (JsonPrimitive)jsonElement).isNumber()) {
                    multiplier = prim.getAsDouble();
                } else {
                    LOGGER.warn("(Respawn Obelisks) Recipe Json at '" + resourceLocation + "' has invalid 'multiplier' section.");
                }
            }
            return new CoreMergeRecipe(super.m_6729_(resourceLocation, jsonObject), multiplier);
        }

        public CoreMergeRecipe fromNetwork(ResourceLocation resourceLocation, FriendlyByteBuf buf) {
            return new CoreMergeRecipe(super.m_8005_(resourceLocation, buf), buf.readDouble());
        }

        public void m_6178_(FriendlyByteBuf buf, ShapelessRecipe shapelessRecipe) {
            super.m_6178_(buf, shapelessRecipe);
            if (shapelessRecipe instanceof CoreMergeRecipe) {
                CoreMergeRecipe recipe = (CoreMergeRecipe)shapelessRecipe;
                buf.writeDouble(recipe.multiplier);
            } else {
                buf.writeDouble(1.0);
            }
        }
    }
}

